# Guia de Instalação do Manus CMS (PHP/MySQL) no cPanel

Este guia detalha o processo de instalação e configuração do Manus CMS em um ambiente de hospedagem cPanel.

## 1. Pré-requisitos

Certifique-se de que seu ambiente cPanel atende aos seguintes requisitos:

*   **PHP**: Versão 7.4 ou superior.
*   **MySQL/MariaDB**: Acesso para criar um banco de dados e um usuário.
*   **Acesso a Arquivos**: Via Gerenciador de Arquivos do cPanel ou FTP/SFTP.

## 2. Preparação do Banco de Dados

Você precisará criar um banco de dados e um usuário no cPanel.

1.  **Acesse o cPanel** e navegue até a seção **Bancos de Dados MySQL**.
2.  **Crie um Novo Banco de Dados**:
    *   Insira um nome para o banco de dados (ex: `meucms_db`).
    *   Clique em **Criar Banco de Dados**.
3.  **Crie um Novo Usuário**:
    *   Insira um nome de usuário (ex: `meucms_user`) e uma senha forte.
    *   Clique em **Criar Usuário**.
4.  **Adicione o Usuário ao Banco de Dados**:
    *   Na seção **Adicionar Usuário ao Banco de Dados**, selecione o usuário e o banco de dados que você acabou de criar.
    *   Clique em **Adicionar**.
    *   Na tela seguinte, marque a opção **TODOS OS PRIVILÉGIOS** e clique em **Fazer Alterações**.

## 3. Upload dos Arquivos

1.  **Descompacte** o arquivo ZIP do CMS em seu computador.
2.  **Acesse o Gerenciador de Arquivos** do cPanel.
3.  Navegue até o diretório `public_html` (ou o subdiretório onde deseja instalar o CMS).
4.  **Faça o Upload** de todos os arquivos e pastas do CMS (`admin`, `includes`, `config.php`, `index.php`, etc.) para este diretório.

## 4. Configuração do CMS

O arquivo `config.php` precisa ser editado com as credenciais do banco de dados que você criou.

1.  No Gerenciador de Arquivos do cPanel, localize e **edite** o arquivo `config.php`.
2.  Substitua os valores `seu_banco_de_dados`, `seu_usuario` e `sua_senha` pelas credenciais reais do seu banco de dados no cPanel (o cPanel adiciona um prefixo ao nome do banco e do usuário, como `cpaneluser_meucms_db`).

\`\`\`php
// Configurações do Banco de Dados
define('DB_HOST', 'localhost');
define('DB_NAME', 'cpaneluser_meucms_db'); // Nome completo do banco de dados
define('DB_USER', 'cpaneluser_meucms_user'); // Nome completo do usuário
define('DB_PASS', 'sua_senha_forte'); // Senha do usuário
// ...
define('SITE_URL', 'http://seudominio.com'); // Mude para o seu domínio
\`\`\`

3.  **Salve** as alterações no arquivo `config.php`.

## 5. Importação do Banco de Dados

1.  **Acesse o cPanel** e navegue até a seção **phpMyAdmin**.
2.  Selecione o banco de dados que você criou para o CMS.
3.  Clique na aba **Importar**.
4.  Clique em **Escolher arquivo** e selecione o arquivo `database.sql` que está na pasta do CMS.
5.  Clique em **Executar** na parte inferior da página. As tabelas do CMS serão criadas.

## 6. Criação do Usuário Administrador Inicial

Para criar o primeiro usuário administrador, você deve executar o script `create_admin.php`.

1.  Abra seu navegador e acesse: `http://seudominio.com/create_admin.php` (substitua `seudominio.com` pelo seu domínio).
2.  A página exibirá uma mensagem de sucesso com as credenciais padrão:
    *   **Usuário**: `admin`
    *   **Senha**: `admin123`
3.  **Ação Crítica de Segurança**: Após a execução, **EXCLUA IMEDIATAMENTE** o arquivo `create_admin.php` do seu servidor usando o Gerenciador de Arquivos do cPanel.

## 7. Acesso ao Painel Administrativo

1.  Acesse o painel de administração em: `http://seudominio.com/admin/login.php`
2.  Faça login com as credenciais padrão (`admin`/`admin123`).
3.  **PRIMEIRA AÇÃO**: Por segurança, navegue até a seção de gerenciamento de usuários (se implementada) ou mude a senha padrão `admin123` o mais rápido possível.

Seu Manus CMS está pronto para uso!
