<?php 
include 'header.php'; 

$message = '';

// Adicionar Categoria
if (isset($_POST['add_category'])) {
    $name = sanitize($_POST['name']);
    $slug = generateSlug($name);
    
    $stmt = $pdo->prepare("INSERT INTO categories (name, slug) VALUES (?, ?)");
    if ($stmt->execute([$name, $slug])) {
        $message = "Categoria adicionada com sucesso!";
    }
}

// Excluir Categoria
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $stmt = $pdo->prepare("DELETE FROM categories WHERE id = ?");
    $stmt->execute([$id]);
    $message = "Categoria excluída!";
}

$categories = $pdo->query("SELECT * FROM categories ORDER BY id DESC")->fetchAll();
?>

<div class="card">
    <h2>Gerenciar Categorias</h2>
    <?php if ($message): ?>
        <div style="padding: 10px; background: #d4edda; color: #155724; margin-bottom: 20px; border-radius: 4px;">
            <?php echo $message; ?>
        </div>
    <?php endif; ?>

    <form method="POST" style="display: flex; gap: 10px; align-items: center;">
        <input type="text" name="name" placeholder="Nome da Categoria" required style="margin: 0; flex: 1;">
        <button type="submit" name="add_category" class="btn btn-success">Adicionar</button>
    </form>

    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Nome</th>
                <th>Slug</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($categories as $cat): ?>
            <tr>
                <td><?php echo $cat['id']; ?></td>
                <td><?php echo $cat['name']; ?></td>
                <td><?php echo $cat['slug']; ?></td>
                <td>
                    <a href="categories.php?delete=<?php echo $cat['id']; ?>" class="btn btn-danger" onclick="return confirm('Tem certeza?')">Excluir</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include 'footer.php'; ?>
