<?php
require_once '../config.php';
require_once '../includes/functions.php';

if (!isLoggedIn()) {
    redirect('login.php');
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Painel Administrativo - CMS</title>
    <style>
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; margin: 0; display: flex; min-height: 100vh; background: #f0f2f5; }
        .sidebar { width: 250px; background: #343a40; color: #fff; padding-top: 20px; }
        .sidebar h2 { text-align: center; margin-bottom: 30px; font-size: 1.5rem; }
        .sidebar a { display: block; color: #adb5bd; padding: 15px 25px; text-decoration: none; transition: 0.3s; }
        .sidebar a:hover { background: #495057; color: #fff; }
        .sidebar a.active { background: #007bff; color: #fff; }
        .main-content { flex: 1; padding: 30px; }
        .header-top { display: flex; justify-content: space-between; align-items: center; margin-bottom: 30px; background: #fff; padding: 15px 30px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.05); }
        .card { background: #fff; padding: 20px; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.05); margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; margin-top: 20px; }
        table th, table td { padding: 12px; text-align: left; border-bottom: 1px solid #dee2e6; }
        .btn { padding: 8px 16px; border-radius: 4px; text-decoration: none; cursor: pointer; border: none; font-size: 14px; }
        .btn-primary { background: #007bff; color: #fff; }
        .btn-danger { background: #dc3545; color: #fff; }
        .btn-success { background: #28a745; color: #fff; }
        form input, form select, form textarea { width: 100%; padding: 10px; margin: 10px 0; border: 1px solid #ddd; border-radius: 4px; box-sizing: border-box; }
    </style>
</head>
<body>
    <div class="sidebar">
        <h2>CMS Admin</h2>
        <a href="index.php">Dashboard</a>
        <a href="posts.php">Posts</a>
        <a href="categories.php">Categorias</a>
        <a href="settings.php">Configurações</a>
        <a href="logout.php" style="margin-top: 50px; color: #ff6b6b;">Sair</a>
    </div>
    <div class="main-content">
        <div class="header-top">
            <span>Bem-vindo, <strong><?php echo $_SESSION['username']; ?></strong></span>
            <a href="../index.php" target="_blank" class="btn btn-primary">Ver Site</a>
        </div>
