<?php 
include 'header.php'; 

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = sanitize($_POST['title']);
    $slug = generateSlug($title);
    $content = $_POST['content'];
    $category_id = (int)$_POST['category_id'];
    $status = $_POST['status'];
    $user_id = $_SESSION['user_id'];

    $stmt = $pdo->prepare("INSERT INTO posts (title, slug, content, category_id, status, user_id) VALUES (?, ?, ?, ?, ?, ?)");
    if ($stmt->execute([$title, $slug, $content, $category_id, $status, $user_id])) {
        redirect('posts.php');
    }
}

$categories = $pdo->query("SELECT * FROM categories")->fetchAll();
?>

<div class="card">
    <h2>Novo Post</h2>
    <form method="POST">
        <label>Título</label>
        <input type="text" name="title" required>
        
        <label>Categoria</label>
        <select name="category_id">
            <option value="">Selecione uma categoria</option>
            <?php foreach ($categories as $cat): ?>
                <option value="<?php echo $cat['id']; ?>"><?php echo $cat['name']; ?></option>
            <?php endforeach; ?>
        </select>

        <label>Conteúdo</label>
        <textarea name="content" rows="10" required></textarea>

        <label>Status</label>
        <select name="status">
            <option value="draft">Rascunho</option>
            <option value="published">Publicado</option>
        </select>

        <button type="submit" class="btn btn-success" style="margin-top: 20px;">Salvar Post</button>
    </form>
</div>

<?php include 'footer.php'; ?>
