<?php 
include 'header.php'; 

if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    $stmt = $pdo->prepare("DELETE FROM posts WHERE id = ?");
    $stmt->execute([$id]);
}

$posts = $pdo->query("SELECT p.*, c.name as category_name FROM posts p LEFT JOIN categories c ON p.category_id = c.id ORDER BY p.created_at DESC")->fetchAll();
?>

<div class="card">
    <div style="display: flex; justify-content: space-between; align-items: center;">
        <h2>Gerenciar Posts</h2>
        <a href="post-add.php" class="btn btn-success">Novo Post</a>
    </div>

    <table>
        <thead>
            <tr>
                <th>Título</th>
                <th>Categoria</th>
                <th>Status</th>
                <th>Data</th>
                <th>Ações</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($posts as $post): ?>
            <tr>
                <td><?php echo $post['title']; ?></td>
                <td><?php echo $post['category_name'] ?? 'Sem categoria'; ?></td>
                <td><?php echo $post['status']; ?></td>
                <td><?php echo date('d/m/Y', strtotime($post['created_at'])); ?></td>
                <td>
                    <a href="post-edit.php?id=<?php echo $post['id']; ?>" class="btn btn-primary">Editar</a>
                    <a href="posts.php?delete=<?php echo $post['id']; ?>" class="btn btn-danger" onclick="return confirm('Tem certeza?')">Excluir</a>
                </td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
</div>

<?php include 'footer.php'; ?>
