<?php
require_once 'config.php';
require_once 'includes/functions.php';

// Buscar configurações
$stmt = $pdo->query("SELECT * FROM settings");
$settings = [];
while ($row = $stmt->fetch()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}

// Buscar posts publicados
$posts = $pdo->query("SELECT p.*, c.name as category_name FROM posts p LEFT JOIN categories c ON p.category_id = c.id WHERE p.status = 'published' ORDER BY p.created_at DESC")->fetchAll();
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $settings['site_title'] ?? 'Meu CMS PHP'; ?></title>
    <style>
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; line-height: 1.6; color: #333; margin: 0; background: #f8f9fa; }
        header { background: #343a40; color: #fff; padding: 2rem 0; text-align: center; }
        .container { max-width: 800px; margin: 2rem auto; padding: 0 1rem; }
        article { background: #fff; padding: 2rem; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); margin-bottom: 2rem; }
        article h2 { margin-top: 0; color: #007bff; }
        .meta { font-size: 0.9rem; color: #6c757d; margin-bottom: 1rem; }
        .category { background: #e9ecef; padding: 2px 8px; border-radius: 4px; font-size: 0.8rem; }
        footer { text-align: center; padding: 2rem; color: #6c757d; }
    </style>
</head>
<body>
    <header>
        <h1><?php echo $settings['site_title'] ?? 'Meu CMS PHP'; ?></h1>
        <p><?php echo $settings['site_description'] ?? ''; ?></p>
    </header>

    <div class="container">
        <?php if (empty($posts)):
            <p>Nenhum post encontrado.</p>
        <?php else:
            <?php foreach ($posts as $post): ?>
                <article>
                    <h2><?php echo $post['title']; ?></h2>
                    <div class="meta">
                        Postado em <?php echo date('d/m/Y', strtotime($post['created_at'])); ?>
                        <?php if ($post['category_name']): ?>
                            na categoria <span class="category"><?php echo $post['category_name']; ?></span>
                        <?php endif; ?>
                    </div>
                    <div>
                        <?php echo nl2br(substr($post['content'], 0, 300)); ?>...
                    </div>
                    <a href="post.php?slug=<?php echo $post['slug']; ?>" style="display: inline-block; margin-top: 1rem; color: #007bff; text-decoration: none; font-weight: bold;">Leia mais &rarr;</a>
                </article>
            <?php endforeach; ?>
        <?php endif; ?>
    </div>

    <footer>
        <p>&copy; <?php echo date('Y'); ?> <?php echo $settings['site_title']; ?>. Desenvolvido com Manus CMS.</p>
    </footer>
</body>
</html>
