<?php
require_once 'config.php';
require_once 'includes/functions.php';

$slug = $_GET['slug'] ?? '';

if (empty($slug)) {
    redirect('index.php');
}

$stmt = $pdo->prepare("SELECT p.*, c.name as category_name FROM posts p LEFT JOIN categories c ON p.category_id = c.id WHERE p.slug = ? AND p.status = 'published'");
$stmt->execute([$slug]);
$post = $stmt->fetch();

if (!$post) {
    die("Post não encontrado.");
}

// Buscar configurações
$stmt = $pdo->query("SELECT * FROM settings");
$settings = [];
while ($row = $stmt->fetch()) {
    $settings[$row['setting_key']] = $row['setting_value'];
}
?>
<!DOCTYPE html>
<html lang="pt-br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $post['title']; ?> - <?php echo $settings['site_title']; ?></title>
    <style>
        body { font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; line-height: 1.6; color: #333; margin: 0; background: #f8f9fa; }
        header { background: #343a40; color: #fff; padding: 1rem 0; text-align: center; }
        .container { max-width: 800px; margin: 2rem auto; padding: 0 2rem; background: #fff; border-radius: 8px; box-shadow: 0 2px 4px rgba(0,0,0,0.1); padding-top: 2rem; padding-bottom: 2rem; }
        h1 { color: #333; }
        .meta { font-size: 0.9rem; color: #6c757d; margin-bottom: 2rem; border-bottom: 1px solid #eee; padding-bottom: 1rem; }
        .content { font-size: 1.1rem; }
        .back-link { display: block; margin-top: 2rem; color: #007bff; text-decoration: none; }
        footer { text-align: center; padding: 2rem; color: #6c757d; }
    </style>
</head>
<body>
    <header>
        <a href="index.php" style="color: #fff; text-decoration: none; font-size: 1.5rem; font-weight: bold;"><?php echo $settings['site_title']; ?></a>
    </header>

    <div class="container">
        <h1><?php echo $post['title']; ?></h1>
        <div class="meta">
            Postado em <?php echo date('d/m/Y', strtotime($post['created_at'])); ?>
            <?php if ($post['category_name']): ?>
                na categoria <strong><?php echo $post['category_name']; ?></strong>
            <?php endif; ?>
        </div>
        <div class="content">
            <?php echo nl2br($post['content']); ?>
        </div>
        <a href="index.php" class="back-link">&larr; Voltar para a Home</a>
    </div>

    <footer>
        <p>&copy; <?php echo date('Y'); ?> <?php echo $settings['site_title']; ?></p>
    </footer>
</body>
</html>
